/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public abstract class PACubeOptionsPanel
extends JPanel {
    private HashMap m_options = new HashMap();

    public void init(String[] options, String[] selectedOptions, boolean editable) {
        this.initLayout(options, selectedOptions, editable);
    }

    public abstract int getOptionsValue();

    public boolean isOptionSelected(String option) {
        return ((JCheckBox)this.m_options.get(option)).isSelected();
    }

    private void initLayout(String[] options, String[] selectedOptions, boolean editable) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.getMeasureOptionsPanel(options, selectedOptions, editable), c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add(Box.createHorizontalStrut(1), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add(Box.createHorizontalStrut(1), c);
    }

    private JPanel getMeasureOptionsPanel(String[] options, String[] selectedOptions, boolean editable) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(LineBorder.createGrayLineBorder(), VWResource.SelectWhenMeasureShouldBeUpdated));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        for (int i = 0; i < options.length; ++i) {
            JCheckBox option = new JCheckBox(options[i]);
            option.setEnabled(editable);
            option.setSelected(VWTaskUtil.isEqualToArrayElement(options[i], selectedOptions));
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 10, 0, 0);
            panel.add((Component)option, c);
            this.m_options.put(options[i], option);
            c.gridx = 1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = new Insets(0, 0, 0, 0);
            panel.add(Box.createHorizontalStrut(0), c);
        }
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add(Box.createHorizontalStrut(0), c);
        return panel;
    }
}

